/**********************************************************************************
 * Project: G2HDM - 2 Higgs Doublet Model (type -II) fitting package              *
 * Package: G2HDM                                                                 *
 * Class  : BR_BDeNu                                                              *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *                
 *                                                                                *                                                                          
 **********************************************************************************/

#include <cmath>
#include <iostream>

#include "TMath.h"

#include "Gfitter/GParameterRef.h"
#include "Gfitter/GMath.h"
#include "Gfitter/GConstants.h"

#include "G2HDM/BR_BDeNu.h"

ClassImp(G2HDM::BR_BDeNu)

G2HDM::BR_BDeNu::BR_BDeNu() 
   : Gfitter::GTheory()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
   
   BookParameter( "BR_BDenuSc", &m_BR_BDenuSc );
}

Double_t G2HDM::BR_BDeNu::GetTheoryPrediction() 
{ 
   return m_BR_BDenuSc;
}
