/**********************************************************************************
 * Package: G2HDM                                                                 *
 * Class  : BR_BLepNu                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      B->taunu branching fraction for 2HDM model                                *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef G2HDM_BR_BLepNu
#define G2HDM_BR_BLepNu

#include "G2HDM/G2HDMBase.h"



namespace G2HDM {
   
   class BR_BLepNu : public G2HDMBase {
      
   public:

      BR_BLepNu();
      virtual ~BR_BLepNu() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
      
   protected:

      // SM parameters
      Gfitter::GParameterRef m_tauBu;
      Gfitter::GParameterRef m_Vub;
      Gfitter::GParameterRef m_fBu;

      // full prediction of SM BR ?
      Gfitter::GParameterRef m_BlepNuSM;

      void SetLeptonMass( Double_t m ) { m_mLepton = m; }

   protected:

      Bool_t UseFullSMInput() const { return m_useFullSMInput; }

   private:
      
      Double_t m_mLepton;
      Bool_t   m_useFullSMInput; 

      ClassDef(BR_BLepNu,0)
  };
}

#endif
