/**********************************************************************************
 * Project: G2HDM - 2 Higgs Doublet fitting package                               *
 * Package: G2HDM                                                                 *
 * Class  : BR_BXsg                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * Source: Misiak et al, Phys.Rev.Lett.98:022002,2007, hep-ph/0609232             *
 *                  and P.Gambino and M.Misiak, private communication             *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/

#include <cmath>
#include <iostream>

#include "TMath.h"

#include "Gfitter/GParameterRef.h"
#include "Gfitter/GMath.h"
#include "Gfitter/GConstants.h"

#include "G2HDM/BR_BXsg.h"

//using namespace Gfitter;

ClassImp(G2HDM::BR_BXsg)

G2HDM::BR_BXsg::BR_BXsg() 
   : G2HDM::G2HDMBase()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
   
   //chf include theo uncert. for BR_BXsg
   BookParameter("DeltaBSG_Scale", & m_DeltaBSG_Scale );

}

Double_t G2HDM::BR_BXsg::GetTheoryPrediction() 
{ 
   Double_t tanBeta     = GetTanb();
   Double_t mChargedH   = GetMHch();

   // Reference:  hep-ph/0609232 and P.Gambino and M.Misiak, private communication
   Double_t br2HDM    = 3.271031905753782 
      + 17183.854962716596/std::pow(mChargedH,2) 
      +  3241.8104475530063/mChargedH 
      - 0.02601686082022642/std::pow(tanBeta,2) 
      + 108.23195185181771/(mChargedH*std::pow(tanBeta,2)) 
      - (417.7787577155386*log(mChargedH))/mChargedH 
      -  (8.55579770439047*log(mChargedH))/(mChargedH*std::pow(tanBeta,2)) 
      - (5834.556627991803*std::pow(log(mChargedH),2))/std::pow(mChargedH,2);


   Double_t br_min =  3.033562795123004 
      + 16599.208111263626/std::pow(mChargedH,2) 
      + 3011.1214331418205/mChargedH 
      - 0.024137459977355724/std::pow(tanBeta,2) 
      + 97.92272743338744/(mChargedH*std::pow(tanBeta,2)) 
      - (387.54376212384943*log(mChargedH))/mChargedH 
      - (7.57676954919524*log(mChargedH))/(mChargedH*std::pow(tanBeta,2)) 
      - (5466.103530585923*std::pow(log(mChargedH),2))/std::pow(mChargedH,2);

   br2HDM = br2HDM + m_DeltaBSG_Scale*(br2HDM - br_min);

   return br2HDM;
}
