/**********************************************************************************
 * Project: G2HDM - 2 Higgs Doublet fitting package                               *
 * Package: G2HDM                                                                 *
 * Class  : BR_BXsg                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      B->Xs gamma branching fraction for 2HDM model                             *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef G2HDM_BR_BXsg
#define G2HDM_BR_BXsg

#include "G2HDM/G2HDMBase.h"


   
namespace G2HDM {
   
   class BR_BXsg : public G2HDMBase {
      
   public:

      BR_BXsg();
      virtual ~BR_BXsg() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
      
   protected:

      // SM parameters

      // 2HDM parameters      
      Gfitter::GParameterRef m_DeltaBSG_Scale;

   private:
      
      ClassDef(BR_BXsg,0)
  };
}

#endif
