/**********************************************************************************
 * Package: G2HDM                                                                 *
 * Class  : G2HDMBase                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *           
 *                                                                                *
 **********************************************************************************/

#include <cmath>
#include <iostream>
#include "Riostream.h"

#include "Gfitter/GParameterRef.h"
#include "Gfitter/GVariable.h"

#include "G2HDM/G2HDMBase.h"

ClassImp(G2HDM::G2HDMBase)

G2HDM::G2HDMBase::G2HDMBase() 
   : Gfitter::GTheory(),
   m_MHchScale( Lin ),
   m_tanbScale( Lin )
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
   
   // do we take the full theory, eg, from the global CKM fit ?
   if (Gfitter::gStore()->ExistVariable( "G2HDMFlags::UseLogMHch" )) {
      m_MHchScale = (Gfitter::gStore()->GetVariable( "G2HDMFlags::UseLogMHch" )->GetBoolValue() ? Log : Lin);
   }
   if (Gfitter::gStore()->ExistVariable( "G2HDMFlags::UseLogTanb" )) {
      m_tanbScale = (Gfitter::gStore()->GetVariable( "G2HDMFlags::UseLogTanb" )->GetBoolValue() ? Log : Lin);
   }

   // 2HDM model parameters
   BookParameter( "tanBeta", &m_tanBeta   );
   BookParameter( "MHch",    &m_mChargedH );
}
