/**********************************************************************************
 * Package: G2HDM                                                                 *
 * Class  : R_DTauDeNu                                                            *
 *                                                                                *
 * Description:                                                                   *
 *      B->Dtaunu branching fraction for 2HDM model                               *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef G2HDM_R_DTauDeNu
#define G2HDM_R_DTauDeNu

#include "G2HDM/G2HDMBase.h"

#include "GEW/QPoleMass.h"





namespace G2HDM {
     
   class R_DTauDeNu : public G2HDM::G2HDMBase {
      
   public:

      R_DTauDeNu();
      virtual ~R_DTauDeNu() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
      
   protected:

      // reference to pole quark masses
      GEW::QPoleMass& GetQPoleMass() const { return (GEW::QPoleMass&)*t_QPoleMass; }
      Gfitter::GTheoryRef    t_QPoleMass;

      // SM parameters
      Gfitter::GParameterRef m_mb_MSb;
      Gfitter::GParameterRef m_eps0;

      // 2HDM parameters
      Gfitter::GParameterRef m_f1;
      Gfitter::GParameterRef m_f2;
      Gfitter::GParameterRef m_f3;

   private:
      
      ClassDef(R_DTauDeNu,0)
  };
}

#endif
