/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : A0bFB                                                                 *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of forward-backward asymmetry of b-quarks                      *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/
#include "GEW/A0bFB.h"
#include "GEW/Z0Base.h"

#include "Gfitter/GMath.h"
#include "Gfitter/GTypes.h"

ClassImp(GEW::A0bFB)

GEW::A0bFB::A0bFB() : SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
}

// calculation via effective weak mixing angle 
Double_t GEW::A0bFB::GetTheoryPrediction()
{
   Double_t Ratio_e = 1.0 - 4.0*GetZ0Theory().GetSin2Eff(Gfitter::GTypes::kElectron);
   Double_t Ratio_b = 1.0 - 4.0*Gfitter::GMath::OneThird()*GetZ0Theory().GetSin2Eff(Gfitter::GTypes::kBottom);

   Double_t a0bfb = 3*( Ratio_e/(1+Ratio_e*Ratio_e)*Ratio_b/(1+Ratio_b*Ratio_b) ); 
   
   return a0bfb;
}
