/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : A0cFB                                                                 *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of forward-backward asymmetry of c-quarks                      *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_A0cFB
#define GEW_A0cFB
 
#include "GEW/SMTheoryBuilder.h"

 namespace GEW {

    class A0cFB : public SMTheoryBuilder {
    
    public:

       A0cFB();
       virtual ~A0cFB() {}

       // theory prediction as function of parameters stored in GStore
       Double_t GetTheoryPrediction();

       // not used
       void Initialise() {}
 
    protected:

       ClassDef(A0cFB,0)
    };
 }

#endif
