/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : A0lepFB                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of forward-backward asymmetry of leptons                       *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "GEW/A0lepFB.h"
#include "GEW/Z0Base.h"

#include "Gfitter/GTypes.h"

ClassImp(GEW::A0lepFB)

GEW::A0lepFB::A0lepFB() : SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
}

// calculation via effective weak mixing angle 
Double_t GEW::A0lepFB::GetTheoryPrediction()
{
   Double_t Ratio_e = 1.0 - 4.0*GetZ0Theory().GetSin2Eff(Gfitter::GTypes::kElectron);

   Double_t a0lepfb = 3*( Ratio_e/(1+Ratio_e*Ratio_e)*Ratio_e/(1+Ratio_e*Ratio_e) ); 
    
   return a0lepfb;
}
