/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : A0lepFB                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of forward-backward asymmetry of leptons                       *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_A0lepFB
#define GEW_A0lepFB
 
#include "SMTheoryBuilder.h"

namespace GEW {

   class A0lepFB : public SMTheoryBuilder {
    
   public:

      A0lepFB();
      virtual ~A0lepFB() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
 
   protected:

      ClassDef(A0lepFB,0)
   };
}

#endif
