/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : Ab                                                                    *
 *                                                                                *
 * Description:                                                                   *
 *      Asymmetry paramter of the b-quarks                                        *
 *                                                                                *
 * see corresponding .h file for author and license information                   *
 *                                                                                *     
 **********************************************************************************/
#include "GEW/Ab.h"
#include "GEW/Z0Base.h"

#include "Gfitter/GMath.h"
#include "Gfitter/GTypes.h"

ClassImp(GEW::Ab)

GEW::Ab::Ab() : SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
}

// calculation via effective weak mixing angle 
Double_t GEW::Ab::GetTheoryPrediction()
{
   Double_t Ratio_b = 1.0 - 4.0*Gfitter::GMath::OneThird()*GetZ0Theory().GetSin2Eff(Gfitter::GTypes::kBottom);
   
   Double_t ab = 2*Ratio_b/(1 + Ratio_b*Ratio_b); 
    
   return ab;
}
