/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : Ab                                                                    *
 *                                                                                *
 * Description:                                                                   *
 *      Asymmetry paramter of the b-quarks                                        *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_Ab
#define GEW_Ab

#include "GEW/SMTheoryBuilder.h"

namespace GEW {
   
   class Ab : public SMTheoryBuilder {
    
   public:

      Ab();
      virtual ~Ab() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
 
   protected:

      ClassDef(Ab,0)
   };
}

#endif
