/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : Ac                                                                    *
 *                                                                                *
 * Description:                                                                   *
 *      Asymmetry paramter of the c-quarks                                        *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "GEW/Ac.h"
#include "GEW/Z0Base.h"

#include "Gfitter/GMath.h"
#include "Gfitter/GTypes.h"

ClassImp(GEW::Ac)

GEW::Ac::Ac() : SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
}

// calculation via effective weak mixing angle 
Double_t GEW::Ac::GetTheoryPrediction()
{   
   Double_t Ratio_c = 1.0 - 4.0*Gfitter::GMath::TwoThird()*GetZ0Theory().GetSin2Eff(Gfitter::GTypes::kCharm);

   Double_t ac = 2*Ratio_c/(1+Ratio_c*Ratio_c); 
 
   return ac;
}
