/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : Ac                                                                    *
 *                                                                                *
 * Description:                                                                   *
 *      Asymmetry paramter of the c-quarks                                        *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_Ac
#define GEW_Ac
 
#include "SMTheoryBuilder.h"

namespace GEW {

   class GParameterRef;

   class Ac : public SMTheoryBuilder {
    
   public:

      Ac();
      virtual ~Ac() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
 
   protected:

      ClassDef(Ac,0)
   };
}

#endif
