/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : Alep                                                                  *
 *                                                                                *
 * Description:                                                                   *
 *      Asymmetry paramter of leptons                                             *
 *                                                                                *
 * see corresponding .h file for author and license information                   *
 *                                                                                *     
 **********************************************************************************/
#include "GEW/Alep.h"
#include "GEW/Z0Base.h"

#include "Gfitter/GTypes.h"

using namespace Gfitter;

ClassImp(GEW::Alep)

GEW::Alep::Alep() : SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
}

// calculation via effective weak mixing angle 
Double_t GEW::Alep::GetTheoryPrediction()
{
   Double_t Ratio_e = 1.0 - 4.0*GetZ0Theory().GetSin2Eff(Gfitter::GTypes::kElectron);
  
   Double_t alep = 2*(Ratio_e)/(1 + Ratio_e*Ratio_e);  
    
   return alep;
}
