/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : AlphaQCDAtQ                                                           *
 *                                                                                *
 * Description:                                                                   *
 *      Auxiliary Theory for runnig strong coupling at scale Q                    *
 *      Two options: take alphasMZ from data-card and compute lambdaMS5           *
 *                   take lambdaMS5 and fit it with AlphaQCDAtQ                   *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/

#include "TString.h"
#include "TMath.h"

#include "Gfitter/GParameterRef.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GVariable.h"
#include "Gfitter/GStore.h"
#include "Gfitter/GRootFinder.h"

#include "GEW/AlphaQCDAtQ.h"

using namespace Gfitter;

ClassImp(GEW::AlphaQCDAtQ)

GEW::AlphaQCDAtQ::AlphaQCDAtQ()
   : Gfitter::GTheory()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
 
   BookParameter( "MZ",                    &p_MZ );
   BookTheory   ( "GEW::RunningAlphaQCD" , &t_AlphasRun );

}

void GEW::AlphaQCDAtQ::Initialise()
{
   m_logger << "InstanceName: " << m_instanceName << GEndl;
   m_scale=0.;

   if (m_instanceName == "MZ") {
      m_scale = p_MZ;
      // wrong: needs updates during fit!
   } 

   else if (m_instanceName.IsFloat()) {
      m_scale = m_instanceName.Atof();
   }
   else {
      m_logger << kFATAL 
               << GetName() 
               << " error in InstanceName interpretation: " 
               << m_instanceName << GEndl;
   }
   m_logger << "m_scale: " << m_scale << GEndl;
}

Double_t GEW::AlphaQCDAtQ::GetTheoryPrediction()
{

   Double_t returnValue = 0.; 

   if (TMath::IsNaN(m_scale)) m_logger << kFATAL << "<AlphaQCDAtQ::GetTheoryPrediction> m_scale is NaN !" << GEndl;
   returnValue = GetAlphasRun().EvolveAlphas(m_scale);

   return returnValue;
} 

