/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : AlphaQCDAtQ                                                           *
 *                                                                                *
 * Description:                                                                   *
 *      Auxiliary Theory for strong coupling at scale Q                           *
 *      Two options: take alphasMZ from data-card and compute lambdaMS5           *
 *                   take lambdaMS5 and fit it with AlphaQCDAtQ                   *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_AlphaQCDAtQ
#define GEW_AlphaQCDAtQ

#include "Gfitter/GTheory.h"

#include "GEW/RunningAlphaQCD.h"




namespace GEW {

   class AlphaQCDAtQ : public Gfitter::GTheory  {

   public:
      
      AlphaQCDAtQ();
      virtual ~AlphaQCDAtQ() {}

      Double_t GetTheoryPrediction();

      void Initialise();

   protected:
    
      // reference to AlphasRunning
      RunningAlphaQCD& GetAlphasRun() const { return (RunningAlphaQCD&)*t_AlphasRun; }
      Gfitter::GTheoryRef    t_AlphasRun; 
      
      Gfitter::GParameterRef p_MZ;
   
      Double_t m_scale;

      ClassDef(AlphaQCDAtQ,0)
   };
}

#endif
