/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : DAlphaQED                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Auxiliary Theory of the Delta-Alpha-QED at the Z-pole                     *
 *      leptonic contribution to effective em coupling constant                   *
 *      up to three loops                                                         *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_DAlphaQED
#define GEW_DAlphaQED

#include <complex>

#include "Gfitter/GAuxTheory.h"





namespace GEW {

   class RunningAlphaQCD;

   class DAlphaQED : public Gfitter::GAuxTheory {

   public:
      
      DAlphaQED();
      virtual ~DAlphaQED() {}
      
      // accessors, downcast for using them
      // Delta_Alpha_Had_5
      Double_t DAlphaHad5(){ return p_DAlphaHad; };
      // included top-contribution
      Double_t DAlphaQEDMZt();
      // excluded top-contribution
      Double_t DAlphaQEDMZ();
      
      // Initialise
      void Initialise();

   protected:
      
      // update of flags in case of parameter change
      void UpdateLocalFlags( Gfitter::GReference& ref );
   
      // update parameters
      void Update();

      // leptonic vacumm polarisation
      Double_t DAlphaLep( Double_t s );

      // reference to AlphasRunning
      RunningAlphaQCD& GetAlphasRun() const { return (RunningAlphaQCD&)*t_AlphasRun; }      
      Gfitter::GTheoryRef    t_AlphasRun; 

      // Data-Card values
      Gfitter::GParameterRef p_MZ; 
      Gfitter::GParameterRef p_mt; 
      Gfitter::GParameterRef p_DAlphaHad;
      // only used with GetValue() to achieve the measured value
      Gfitter::GParameterRef p_MW; 

      // member values
      // excluded top cntribution
      Double_t m_DAlphaQED;

      // included top cntribution
      Double_t m_DAlphaQEDtop;

      // charged lepton masses
      Double_t m_mLep2[3];

      // Delta_alpha_top 
      Double_t DAlphatop( Double_t s );
      
   private:

      // boolean flags to track recomputation
      Bool_t m_isUpToDate_Update; 

      ClassDef(DAlphaQED,0)
   };
}

//----------------------------- inline functions ---------------------------------------

inline Double_t GEW::DAlphaQED::DAlphaQEDMZt()
{
   Update();
   return m_DAlphaQEDtop;
}

inline Double_t GEW::DAlphaQED::DAlphaQEDMZ()
{
   Update();
   return m_DAlphaQED;
}


#endif
