/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : GammaWtot                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of total width of W boson                                      *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_GammaWtot
#define GEW_GammaWtot

#include "GEW/SMTheoryBuilder.h"



namespace GEW {

   class RadiatorFunctions;
    
   class GammaWtot : public SMTheoryBuilder {

   public:
      
      GammaWtot();
      ~GammaWtot() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {};

   protected:
      
      ClassDef(GammaWtot,0)
   };
}

#endif
