/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : GammaWtot                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of the total Z width                                           *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "GEW/GammaZtot.h"
#include "GEW/Z0Base.h"

ClassImp(GEW::GammaZtot)

GEW::GammaZtot::GammaZtot() : SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
}

Double_t GEW::GammaZtot::GetTheoryPrediction()
{   
   Double_t GaZnu  = GetZ0Theory().GetGaZneutrino(); 
   Double_t GaZe   = GetZ0Theory().GetGaZelectron();  
   Double_t GaZmu  = GetZ0Theory().GetGaZmuon(); 
   Double_t GaZtau = GetZ0Theory().GetGaZtau();
   Double_t GaZhad = GetZ0Theory().GetGaZhad();  
         
   Double_t gaztot = 3.0*GaZnu + GaZe + GaZmu + GaZtau + GaZhad;
      
   return gaztot;
}
