/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : HiggsTrivialityBound                                                  *
 *                                                                                *
 * Description:                                                                   *
 *      Bound obtained from triviality requirement (Landau pole)                  *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
**********************************************************************************/

#ifndef GEW_HiggsTrivialityBound
#define GEW_HiggsTrivialityBound

#include "GEW/HiggsTheoryBound.h"

class TGraph;

namespace GEW {

   class HiggsTrivialityBound : public GEW::HiggsTheoryBound {

   public:
      
      HiggsTrivialityBound();
      ~HiggsTrivialityBound() {}      

      // Initialise coefficients
      void Initialise();
      
   protected:

      Gfitter::GParameterRef p_mt;

      Gfitter::GTheory&      GetAlphasMZ() const { return (Gfitter::GTheory&)*t_AlphasMZ; }      
      Gfitter::GTheoryRef    t_AlphasMZ; 

      const TGraph*          m_pb_ref; // graph for triviality bound - reference

      Double_t GetCriticalMass();

   private:

      ClassDef(HiggsTrivialityBound,0)
   };
}

#endif
