/**********************************************************************************
 * Project: GEW - SM Paramter fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : MH                                                                    *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "TMath.h"

#include "Gfitter/GVariable.h"
#include "Gfitter/GStore.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GParameterRef.h"
#include "Gfitter/GReference.h"

#include "GEW/MH.h"
#include "GEW/GHiggsTheoryBase.h"

using namespace Gfitter;

ClassImp(GEW::MH)

GEW::MH::MH()
   : Gfitter::GAuxTheory()
   , m_isUpToDate_Update(kFALSE)
   , m_value(1.0)
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   Initialise();
}


void
GEW::MH::Initialise() 
{
  /// Initialization goes here
  TString replace = "SM";
  if ( gStore()->ExistVariable( "GEWFlags::HiggsTheory" ) ) {
    replace = gStore()->GetVariable( "GEWFlags::HiggsTheory" )->GetStringValue();
    m_logger << kINFO << "Using Higgs Theory: \"" << replace << "\"" << GEndl;
  }

  if      (replace == "SM" )       m_replace = kSM;
  else if (replace == "SUSY")      m_replace = kSUSY;
  else if (replace == "FeynHiggs") m_replace = kFeynHiggs;
  else if (replace == "SoftSusy")  m_replace = kSoftSusy;
  else {
     m_logger << kFATAL << "unknown theory for \"GEWFlags::HiggsTheory\": \"" << replace << "\""
              << ". Possible are: \"SM\", \"SUSY\", \"FeynHiggs\" and \"SoftSusy\""
              << GEndl;
  }

  // SM
  if( IsSM() ){
     BookParameter( "MH", &p_MH );
  }
  // Susy or FeynHiggs
  else if( IsSUSY() || IsFeynHiggs() ){
     BookTheory   ( "GSUSY::GFeynHiggsWrapper", &t_theory );
  }
  // SoftSusy
  else if( IsSoftSusy() ){
     BookTheory   ( "GSUSY::GSoftSusyWrapper", &t_theory );
  }
  else {
     m_logger << kFATAL << "<MH>: Unknown Higgs theory!!!" << GEndl;
  }
}


// return Higgs mass value
Double_t 
GEW::MH::GetValue()
{
   Update();
   return m_value;
}


void 
GEW::MH::UpdateLocalFlags( Gfitter::GReference&  )
{
  m_isUpToDate_Update = kFALSE;
}


void 
GEW::MH::Update()
{
  if(m_isUpToDate_Update) return;  
  m_isUpToDate_Update = kTRUE;
  
  if( IsSM() ){
     m_value = p_MH;
  }
  else {
     m_value = GetTheory().Get_Mh();
  }

  SetUpToDate(); 
}

