/**********************************************************************************
 * Project: GEW - SM Paramter fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : MH                                                                    *
 *                                                                                *
 * Description:                                                                   *
 *      auxiliary class (neede for SUSY models, etc.)                             *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
**********************************************************************************/

#ifndef GEW_MH
#define GEW_MH

#include "Gfitter/GAuxTheory.h"




namespace GEW {
   
   class GHiggsTheoryBase;
   
   class MH : public Gfitter::GAuxTheory {

   public:
      
      MH();
      ~MH() {}

      // Initialise coefficients
      void Initialise();

      // Get higgs mass
      Double_t GetValue();

   protected:

      /// update of flags in case of parameter change
      void UpdateLocalFlags( Gfitter::GReference& ref );
    
      /// update parameters
      void Update();

      // Higgs mass parameter
      Gfitter::GParameterRef p_MH;

      // reference to TheoryBase
      GHiggsTheoryBase& GetTheory() const { return (GHiggsTheoryBase&)*t_theory; }
      Gfitter::GTheoryRef t_theory;

      Bool_t m_isUpToDate_Update;
      Double_t m_value;

   private:

      // Theory flag
      enum HiggsType { kSM = 1, kSUSY, kFeynHiggs, kSoftSusy };
      HiggsType m_replace;
      
      Bool_t IsSM()         const { return (m_replace == kSM)        ? kTRUE : kFALSE; }
      Bool_t IsSUSY()       const { return (m_replace == kSUSY)      ? kTRUE : kFALSE; }
      Bool_t IsFeynHiggs()  const { return (m_replace == kFeynHiggs) ? kTRUE : kFALSE; }
      Bool_t IsSoftSusy()   const { return (m_replace == kSoftSusy)  ? kTRUE : kFALSE; }

      ClassDef(MH,0)
   };
}

#endif

