/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : MWTree                                                                *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of W mass at tree level                                        *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "TMath.h"
#include "TString.h"
#include "Riostream.h"

#include "Gfitter/GMath.h"
#include "Gfitter/GConstants.h"
#include "Gfitter/GTheory.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GParameterRef.h"
#include "Gfitter/GReference.h"
#include "Gfitter/GVariable.h"
#include "Gfitter/GStore.h"

#include "GEW/MWTree.h"
#include "GEW/DAlphaQED.h"

using namespace Gfitter;

ClassImp(GEW::MWTree)

GEW::MWTree::MWTree()
   : Gfitter::GTheory()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
  
   BookParameter( "MZ",             &p_MZ );   
   BookParameter( "GF",             &p_GF );   
   BookTheory   ( "GEW::DAlphaQED", &t_DAlphaQED );   
}

// init coefficients
void GEW::MWTree::Initialise()
{}

Double_t GEW::MWTree::GetTheoryPrediction()
{
   Double_t alphaQEDMZ = GConstants::alphaQED()/( 1.0 - GetDAlphaQED().DAlphaQEDMZt() );

   Double_t mW = 1.0 + TMath::Sqrt( 1.0 - TMath::Sqrt(8.0)*TMath::Pi()*alphaQEDMZ/(p_GF*p_MZ*p_MZ) );
   mW = p_MZ*TMath::Sqrt(0.5*mW);

   return mW;
}
