/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : MWTree                                                                *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of W mass at tree level                                        *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GEW_MWTree
#define GEW_MWTree

#include "Gfitter/GTheory.h"




namespace GEW {

   class DAlphaQED;

   class MWTree : public Gfitter::GTheory {

   public:
      
      MWTree();
      ~MWTree() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise();

   protected:
    
      // parameters from the Data-Card
      Gfitter::GParameterRef p_MZ;
      Gfitter::GParameterRef p_GF;

      // reference to DAlphaQED
      DAlphaQED& GetDAlphaQED() const { return (DAlphaQED&)*t_DAlphaQED; }      
      Gfitter::GTheoryRef    t_DAlphaQED; 
       
      ClassDef(MWTree,0)
   };
}

#endif
