/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : QMassRunning                                                          *
 *                                                                                *
 * Description:                                                                   *
 *      Auxiliary Theory for running quark masses ( only charms and bottoms )     *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GEW_QMassRunning
#define GEW_QMassRunning

#include "Gfitter/GAuxTheory.h"
#include "Gfitter/GTypes.h"




using namespace Gfitter;

namespace GEW {

   class RunningAlphaQCD;

   class QMassRunning : public Gfitter::GAuxTheory {

   public:
      
      QMassRunning();
      ~QMassRunning() {}

      // not used in Aux Theories
      Double_t GetTheoryPrediction() { return 0; }
    
      // accessor; downcast for uising it
      Double_t GetRunningQuarkMass( Gfitter::GTypes::Particle particle );
   
      // not used
      void Initialise() {};

   protected:

      // MS-bar runnig quark masses
      Double_t EvolveMass      ( Double_t m, Double_t alphas, Gfitter::GTypes::Particle particle );
      Double_t MSMassRunning   ( Gfitter::GTypes::Particle particle );
          
      // reference to AlphasRunning
      RunningAlphaQCD& GetAlphasRun() const { return (RunningAlphaQCD&)*t_AlphasRun; }
      Gfitter::GTheoryRef    t_AlphasRun; 

      // reference to AlphasMZ
      Gfitter::GTheory& GetAlphasMZ() const { return (Gfitter::GTheory&)*t_AlphasMZ; }   
      Gfitter::GTheoryRef    t_AlphasMZ; 
    
      // quark masses (at pole)
      Gfitter::GParameterRef p_mc; 
      Gfitter::GParameterRef p_mb; 
 
      ClassDef(QMassRunning,0)

   };
}

// inline function for fast access
inline Double_t GEW::QMassRunning::GetRunningQuarkMass( Gfitter::GTypes::Particle particle )
{
   return MSMassRunning( particle );
}

#endif
