/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : R0b                                                                   *
 *                                                                                *
 * Description:                                                                   *
 *       Ratio of the bottoms partial Z width to all hadrons                      *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "GEW/R0b.h"
#include "GEW/Z0Base.h"

ClassImp(GEW::R0b)

GEW::R0b::R0b() : SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   // use full two loop calculation, i.e parametrized formual of paper (i)
   m_fullTwoLoop = kTRUE;

   if( m_fullTwoLoop ){
      BookTheory   ( "GEW::R0bParametrisation",  &t_r0b );   
   }
}


Double_t GEW::R0b::GetTheoryPrediction()
{   
   Double_t r0b = 0;

   // paramtrized formula (full-two loop)
   if( m_fullTwoLoop ){
      
      r0b = GetR0bPara().GetR0b();
   }
   // using calculation from Z0Paramtrisation
   else{
      Double_t GaZhad = GetZ0Theory().GetGaZhad();
      Double_t GaZb   = GetZ0Theory().GetGaZbottom();
      
      r0b = GaZb/GaZhad;
   }

   return r0b;
}
