/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : R0b                                                                   *
 *                                                                                *
 * Description:                                                                   *
 *      Ratio of the bottoms partial Z width to all hadrons                       *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GEW_R0b
#define GEW_R0b
 
#include "GEW/SMTheoryBuilder.h"
#include "GEW/R0bParametrisation.h"




namespace GEW {

   class R0b : public SMTheoryBuilder {
    
   public:

      R0b();
      virtual ~R0b() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {};
 
   protected:
  
      // reference to full two-loop R0b calculation (partametrisation)
      R0bParametrisation& GetR0bPara() const { return (R0bParametrisation&)*t_r0b; }
      Gfitter::GTheoryRef  t_r0b;
      
      Bool_t m_fullTwoLoop;
            
      ClassDef(R0b,0)
   };
}

#endif
