/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : R0bParametrisation                                                    *
 *                                                                                *
 * Description:                                                                   *
 *      Ratio of the bottoms partial Z width to all hadrons (full two loop)       *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GEW_R0bParametrisation
#define GEW_R0bParametrisation
 
#include "Gfitter/GAuxTheory.h"
#include "Gfitter/GTypes.h"
#include "GEW/DAlphaQED.h"
#include "GEW/AlphaQCDAtQ.h"
#include "GEW/MH.h"





namespace GEW {

   class R0bParametrisation : public Gfitter::GAuxTheory {
    
   public:

      R0bParametrisation();
      virtual ~R0bParametrisation() {}

      // return R0b value
      Double_t GetR0b();

      // not used
      void Initialise();
 
   protected:

      // parameters from the Data-Card
      Gfitter::GParameterRef p_mt;
      Gfitter::GParameterRef p_MZ;
  
      // reference to DAlphaQED
      DAlphaQED& GetDAlphaQED() const { return (DAlphaQED&)*t_DAlphaQED; }      
      Gfitter::GTheoryRef    t_DAlphaQED; 
       
      // reference to AlphasMZ
      Gfitter::GTheory& GetAlphasMZ() const { return (Gfitter::GTheory&)*t_AlphasMZ; } 
      Gfitter::GTheoryRef    t_AlphasMZ; 

      // reference to Higgs mass
      GEW::MH& GetMH() const{ return (GEW::MH&)*t_MH; }
      Gfitter::GTheoryRef t_MH;

      // coefficients for the parameterized equation
      Double_t m_r0b;
      Double_t m_c1;
      Double_t m_c2;
      Double_t m_c3;
      Double_t m_c4; 
      Double_t m_c5;
      Double_t m_c6;
      Double_t m_c7;
      Double_t m_c8;
      Double_t m_c9;
      Double_t m_c10;
     
      Bool_t m_logMH;
      
      ClassDef(R0bParametrisation,0)
   };
}

#endif
