/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : R0c                                                                   *
 *                                                                                *
 * Description:                                                                   *
 *      Ratio of the charms partial Z width to all hadrons                        *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "GEW/R0c.h"
#include "GEW/Z0Base.h"

ClassImp(GEW::R0c)

GEW::R0c::R0c() : SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
}

Double_t GEW::R0c::GetTheoryPrediction()
{   
   Double_t GaZhad = GetZ0Theory().GetGaZhad();
   Double_t GaZc   = GetZ0Theory().GetGaZcharm();
          
   Double_t r0c = GaZc/GaZhad;
   
   return r0c;
}
