/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : R0c                                                                   *
 *                                                                                *
 * Description:                                                                   *
 *      Ratio of the charms partial Z width to all hadrons                        *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "GEW/R0lep.h"
#include "GEW/Z0Base.h"

ClassImp(GEW::R0lep)

GEW::R0lep::R0lep() : SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
}

Double_t GEW::R0lep::GetTheoryPrediction()
{
   Double_t GaZe   = GetZ0Theory().GetGaZelectron();
   Double_t GaZhad = GetZ0Theory().GetGaZhad();
      
   Double_t r0lep = GaZhad/GaZe;
    
   return r0lep;
}
