/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : Sigma0had                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of hadronic cross-section                                      *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "TMath.h"

#include "Gfitter/GMath.h"

#include "GEW/Sigma0had.h"
#include "GEW/Z0Base.h"

ClassImp(GEW::Sigma0had)

GEW::Sigma0had::Sigma0had() : SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   BookParameter( "MZ" , &m_MZ );
}

Double_t GEW::Sigma0had::GetTheoryPrediction()
{   

   Double_t GaZnu  = GetZ0Theory().GetGaZneutrino();

   Double_t GaZe   = GetZ0Theory().GetGaZelectron();
   Double_t GaZmu  = GetZ0Theory().GetGaZmuon();
   Double_t GaZtau = GetZ0Theory().GetGaZtau();

   Double_t GaZhad = GetZ0Theory().GetGaZhad();
  
   Double_t GaZtot = 3.0*GaZnu + GaZe + GaZmu + GaZtau + GaZhad;
   
   // and conversion from GeV to nano-barn
   Double_t sigma0had = ( 12.0*TMath::Pi()*GaZe*
                          GaZhad/Gfitter::GMath::IPow(GaZtot*m_MZ,2)*
                          Gfitter::GMath::IPow(1.97327,2)*1e5 ); 
   
   return sigma0had;
   
   
}
