/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : Sigma0had                                                             *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of hadronic cross-section                                      *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_Sigma0had
#define GEW_Sigma0had
 
#include "GEW/SMTheoryBuilder.h"



namespace GEW {

   class Sigma0had : public SMTheoryBuilder {
    
   public:

      Sigma0had();
      virtual ~Sigma0had() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
 
   protected:

      Gfitter::GParameterRef m_MZ;

      ClassDef(Sigma0had,0)
   };
}

#endif
