/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : Sin2TheatF                                                            *
 *                                                                                *
 * Description:                                                                   *
 *      Auxiliary Theory for the effective weak mixing angle (includes 2 loops)   *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_Sin2ThetaF
#define GEW_Sin2ThetaF

#include "Gfitter/GAuxTheory.h"
#include "Gfitter/GTypes.h"





namespace GEW {

   class MH;
   class DAlphaQED;

   class Sin2ThetaF : public Gfitter::GAuxTheory {

   public:
      
      Sin2ThetaF();
      ~Sin2ThetaF() {}

      // accessor, downcast for using it
      // nf = flavor
      // -1 = charged leptons
      //  0 = neutrinos
      //  1 = up
      //  2 = down
      //  3 = strange
      //  4 = charm
      //  5 = bottom
      Double_t GetSin2ThetaF( Gfitter::GTypes::Particle p );

      // Initialise coefficients
      void Initialise();

   protected:
      
      // parameters from Data-Card
      Gfitter::GParameterRef p_mt;
      Gfitter::GParameterRef p_MZ;
      Gfitter::GParameterRef p_GF;
      Gfitter::GParameterRef p_DeltaSin2ThetaF_Scale;

      // reference to DAlphaQED
      DAlphaQED& GetDAlphaQED() const { return (DAlphaQED&)*t_DAlphaQED; }      
      Gfitter::GTheoryRef    t_DAlphaQED; 

      // reference to AlphasMZ
      Gfitter::GTheory& GetAlphasMZ() const { return (Gfitter::GTheory&)*t_AlphasMZ; } 
      Gfitter::GTheoryRef    t_AlphasMZ; 

      // reference to Higgs mass
      GEW::MH& GetMH() const{ return (GEW::MH&)*t_MH; }
      Gfitter::GTheoryRef t_MH;

      // coefficients for parametrizied equation
      Double_t m_s0[5];
      Double_t m_d1[5];
      Double_t m_d2[5];
      Double_t m_d3[5];
      Double_t m_d4[5];
      Double_t m_d5[5];
      Double_t m_d6[5];
      Double_t m_d7[5];
      Double_t m_d8[5];
      Double_t m_d9[5];
      Double_t m_d10[5];
      Double_t m_d11[5];

      Bool_t m_logMH;      
    
      ClassDef(Sin2ThetaF,0)
   };
}

#endif
