/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : WBase                                                                 *
 *                                                                                *
 * Description:                                                                   *
 *      Implemantation of base class                                              *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "TMath.h"

#include "Gfitter/GMath.h"
#include "Gfitter/GConstants.h"
#include "Gfitter/GTheory.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GParameterRef.h"
#include "Gfitter/GReference.h"

#include "GEW/WBase.h"

using namespace Gfitter;
using std::complex;

ClassImp(GEW::WBase)
   
GEW::WBase::WBase(): Gfitter::GAuxTheory()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
   
   BookParameter( "MZ", &p_MZ );
   BookParameter( "GF", &p_GF );   
}

