/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : WParametrisation                                                      *
 *                                                                                *
 * Description:                                                                   *
 *      W Boson decay / total width                                               *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_WParametrisation
#define GEW_WParametrisation

#include <complex>

#include "GEW/WBase.h"
#include "GEW/MH.h"





namespace GEW {

   class WParametrisation : public WBase {

   public:
      
      WParametrisation();
      virtual ~WParametrisation() {}
    
      // not used
      void Initialise() {};

      Double_t GetGammaW(){  Update(); return m_gammaW; };
   
   protected:
      
      // update of flags in case of parameter change
      void UpdateLocalFlags( Gfitter::GReference& ref );
   
      // update parameters
      void Update();
      
      // reference to Higgs mass
      GEW::MH& GetMH() const{ return (GEW::MH&)*t_MH; }
      Gfitter::GTheoryRef t_MH;
      
      // reference to W mass
      Gfitter::GTheory& GetMW() const { return (Gfitter::GTheory&)*m_MW; }      
      Gfitter::GTheoryRef m_MW; 

      // reference to AlphasMZ
      Gfitter::GTheory& GetAlphasMZ() const { return (Gfitter::GTheory&)*t_AlphasMZ; }      
      Gfitter::GTheoryRef t_AlphasMZ; 

      Bool_t m_logMH;
    
   private:

      // boolean flags to track recomputation
      Bool_t m_isUpToDate_Update; 

      ClassDef(WParametrisation,0)
   };
}

#endif
