/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : Z0Base                                                                *
 *                                                                                *
 * Description:                                                                   *
 *      Base class for EW fits (Z0 properties)                                    *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/
#include "TMath.h"

#include "Gfitter/GMath.h"
#include "Gfitter/GConstants.h"
#include "Gfitter/GParameterRef.h"
#include "Gfitter/GTheoryRef.h"

#include "GEW/Sin2ThetaF.h"
#include "GEW/DAlphaQED.h"
#include "GEW/MH.h"


#include "GEW/Z0Base.h"

using namespace Gfitter;

ClassImp(GEW::Z0Base)

GEW::Z0Base::Z0Base()
   : Gfitter::GAuxTheory()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   BookParameter( "mt", &p_mt );  
   BookParameter( "MZ", &p_MZ );   
   BookParameter( "GF", &p_GF );

   BookTheory   ( "GEW::MH"                    , &t_MH );
   BookTheory   ( "GEW::AlphaQCDAtQ/MZ"        , &t_AlphasMZ );   
   BookTheory   ( "GEW::DAlphaQED"             , &t_DAlphaQED );
   BookTheory   ( "GEW::Sin2ThetaF"            , &t_sineff );
}




