/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : gAeff                                                                 *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of axial-vector coupling                                       *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_gAeff
#define GEW_gAeff

#include "GEW/SMTheoryBuilder.h"
#include "Gfitter/GTypes.h"

namespace GEW {

   class gAeff :  public SMTheoryBuilder {

   public:
      
      gAeff();
      virtual ~gAeff() {}

      Double_t GetTheoryPrediction();

      void Initialise();

   protected:

      Gfitter::GTypes::Particle m_type;
      Double_t m_T3;
      Double_t m_Q;
    
      ClassDef(gAeff,0)
   };
}

#endif
