/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : gVeff                                                                 *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of vector coupling                                             *
 *                                                                                *
 * see corresponding .h file for author and license information                   *     
 *                                                                                *
 **********************************************************************************/

#include "TString.h"
#include "TMath.h"

#include "Gfitter/GVariable.h"
#include "Gfitter/GStore.h"

#include "GEW/gVeff.h"
#include "GEW/GammaZtot.h"
#include "GEW/Z0Base.h"

using namespace Gfitter;

ClassImp(GEW::gVeff)

GEW::gVeff::gVeff(): SMTheoryBuilder()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );
}

void GEW::gVeff::Initialise()
{
   m_logger << "InstanceName: " << m_instanceName << GEndl;

   if (m_instanceName == "Electron"){
      m_type = GTypes::kElectron;
      m_T3   = -0.5;
      m_Q    = -1;
   }
   else if (m_instanceName == "Neutrino"){
      m_type = GTypes::kNeutrino;
      m_T3   = 0.5;
      m_Q    = 0;
   }
     else if (m_instanceName == "Up"){
      m_type = GTypes::kUp;
      m_T3   = 0.5;
      m_Q    = 2/3.;
   }
   else if (m_instanceName == "Down"){
      m_type = GTypes::kDown;
      m_T3   = -0.5;
      m_Q    = -1/3.;
   }
   else if (m_instanceName == "Strange"){
      m_type = GTypes::kStrange;
      m_T3   = -0.5;
      m_Q    = -1/3.;
   }
   else if (m_instanceName == "Charm"){
      m_type = GTypes::kCharm;
      m_T3   = 0.5;
      m_Q    = 2/3.;
   }
   else if (m_instanceName == "Bottom"){
      m_type = GTypes::kBottom;
      m_T3   = -0.5;
      m_Q    = -1/3.;
   }
   else {
      m_logger << kFATAL << GetName() << " error in InstanceName interpretation: " << m_instanceName << GEndl;
   }   
}

Double_t GEW::gVeff::GetTheoryPrediction()
{

   Double_t returnValue = GetZ0Theory().GetgVeff( m_type, m_T3, m_Q );

   return returnValue;
} 

