/**********************************************************************************
 * Project: GEW - Electroweak fitting package                                     *
 * Package: GEW                                                                   *
 * Class  : gVeff                                                                 *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of vector coupling                                             *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GEW_gVeff
#define GEW_gVeff

#include "GEW/SMTheoryBuilder.h"
#include "Gfitter/GTypes.h"

namespace GEW {

   class gVeff :  public SMTheoryBuilder {

   public:
      
      gVeff();
      virtual ~gVeff() {}

      Double_t GetTheoryPrediction();

      void Initialise();

   protected:

      Gfitter::GTypes::Particle m_type;
      Double_t m_T3;
      Double_t m_Q;
        
      ClassDef(gVeff,0)
   };
}

#endif
