/**********************************************************************************
 * Project: GOblique - Electroweak fitting package                                *
 * Package: GOblique                                                              *
 * Class  : Epsilon3                                                              *
 *                                                                                *
 * Description:                                                                   *
 *      epsilon3                                                                  *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/
#include "GOblique/Epsilon3.h"

#include "Gfitter/GParameterRef.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GTypes.h"

#include "GOblique/EpsilonParametrisation.h"

ClassImp(GOblique::Epsilon3)

GOblique::Epsilon3::Epsilon3()
   : Gfitter::GTheory()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   BookTheory   ( "GOblique::EpsilonParametrisation", &t_Para );  
}

Double_t GOblique::Epsilon3::GetTheoryPrediction()
{
   return GetPara().GetEpsilon3();
}
