/**********************************************************************************
 * Project: GOblique - Electroweak fitting package                                *
 * Package: GOblique                                                              *
 * Class  : EpsilonParametrisation                                                *
 *                                                                                *
 * Description:                                                                   *
 *      Epsilon Parametrisation                                                   *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/

#ifndef GOblique_EpsilonParametrisation
#define GOblique_EpsilonParametrisation

#include "Gfitter/GAuxTheory.h"

#include "GEW/DAlphaQED.h"
#include "GEW/Z0Base.h"
#include "GEW/MW.h"




namespace GOblique {
 
   class DAlphaQED;
   class Z0Base;

   class EpsilonParametrisation : public Gfitter::GAuxTheory {

   public:
      
      EpsilonParametrisation();
      ~EpsilonParametrisation() {}

      void Initialise() {}

      // accessors
      Double_t GetS(); 
      Double_t GetT(); 
      Double_t GetU(); 
      Double_t GetGammab(); 

      Double_t GetEpsilon1(); 
      Double_t GetEpsilon2(); 
      Double_t GetEpsilon3(); 
      Double_t GetEpsilonb(); 

   protected:

      // update of flags in case of parameter change
      void UpdateLocalFlags( Gfitter::GReference& ref );
   
      // update parameters
      void Update();

      // updated values
      Double_t m_alphaMZ;
      Double_t m_s02;
      Double_t m_c02;
      
      // epsilon parameters
      Double_t m_epsilon1;
      Double_t m_epsilon2;
      Double_t m_epsilon3;
      Double_t m_epsilonb;

      // epsilon parameters
      Double_t m_S;
      Double_t m_T;
      Double_t m_U;
      Double_t m_Gammab;

      // parameters
      Gfitter::GParameterRef p_GF;
      Gfitter::GParameterRef p_MZ;
      Gfitter::GParameterRef p_mt;
      Gfitter::GParameterRef p_MH;
       
      // reference to W mass
      GEW::MW& GetMW() { return (GEW::MW&)*t_MW; }
      Gfitter::GTheoryRef t_MW;
      
      // reference to DAlphaQED
      GEW::DAlphaQED& GetDAlphaQED() const { return (GEW::DAlphaQED&)*t_DAlphaQED; }      
      Gfitter::GTheoryRef t_DAlphaQED; 
      
      // reference to Z0Base
      GEW::Z0Base& GetZ0Theory() { return (GEW::Z0Base&)*t_z0Theory; }
      Gfitter::GTheoryRef t_z0Theory;
      
   private:

      // boolean flags to track recomputation
      Bool_t m_isUpToDate_Update; 

      ClassDef(EpsilonParametrisation,0)
   };
}

#endif


