/**********************************************************************************
 * Project: GOblique - Electroweak fitting package                                *
 * Package: GOblique                                                              *
 * Class  : Epsilonb                                                              *
 *                                                                                *
 * Description:                                                                   *
 *      epsilonb                                                                  *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GOblique_Epsilonb
#define GOblique_Epsilonb
 
#include "Gfitter/GTheory.h"



namespace GOblique {

   class EpsilonParametrisation;

   class Epsilonb : public Gfitter::GTheory {
    
   public:

      Epsilonb();
      virtual ~Epsilonb() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
 
   protected:

      // reference to EpsilonParametrisation
      EpsilonParametrisation& GetPara() const { return (EpsilonParametrisation&)*t_Para; }  
      Gfitter::GTheoryRef    t_Para;  
      
      ClassDef(Epsilonb,0)
   };
}

#endif


