/**********************************************************************************
 * Project: GOblique - Electroweak fitting package                                *
 * Package: GOblique                                                              *
 * Class  : Gammab                                                                *
 *                                                                                *
 * Description:                                                                   *
 *      Gammab Parameter                                                          *
 *                                                                                *
 * see corresponding .h file for author and license information                   *
 *                                                                                *         
 **********************************************************************************/
#include "GOblique/Gammab.h"

#include "Gfitter/GParameterRef.h"
#include "Gfitter/GTheoryRef.h"
#include "Gfitter/GTypes.h"

#include "GOblique/EpsilonParametrisation.h"

ClassImp(GOblique::Gammab)

GOblique::Gammab::Gammab()
   : Gfitter::GTheory()
{
   SetTheoryName( GetName() );
   SetExistDerivative( kFALSE );

   BookTheory   ( "GOblique::EpsilonParametrisation", &t_Para );  
}

Double_t GOblique::Gammab::GetTheoryPrediction()
{
   return GetPara().GetGammab();
}
