/**********************************************************************************
 * Project: GOblique - Electroweak fitting package                                *
 * Package: GOblique                                                              *
 * Class  : Gammab                                                                *
 *                                                                                *
 * Description:                                                                   *
 *      Gammab Parameter                                                          *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GOblique_Gammab
#define GOblique_Gammab
 
#include "Gfitter/GTheory.h"



namespace GOblique {

   class EpsilonParametrisation;

   class Gammab : public Gfitter::GTheory {
    
   public:

      Gammab();
      virtual ~Gammab() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
 
   protected:

      // reference to EpsilonParametrisation
      EpsilonParametrisation& GetPara() const { return (EpsilonParametrisation&)*t_Para; }  
      Gfitter::GTheoryRef    t_Para;  
      
      ClassDef(Gammab,0)
   };
}

#endif


