/**********************************************************************************
 * Project: GOblique - Electroweak fitting package                                *
 * Package: GOblique                                                              *
 * Class  : S                                                                     *
 *                                                                                *
 * Description:                                                                   *
 *      S Parameter                                                               *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GOblique_S
#define GOblique_S
 
#include "Gfitter/GTheory.h"



namespace GOblique {

   class EpsilonParametrisation;

   class S : public Gfitter::GTheory {
    
   public:

      S();
      virtual ~S() {}

      // theory prediction as function of parameters stored in GStore
      Double_t GetTheoryPrediction();

      // not used
      void Initialise() {}
 
   protected:

      // reference to EpsilonParametrisation
      EpsilonParametrisation& GetPara() const { return (EpsilonParametrisation&)*t_Para; }  
      Gfitter::GTheoryRef    t_Para;  
      
      ClassDef(S,0)
   };
}

#endif


