/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : A0lepFB                                                               *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * Source:                                                                        *
 *      - C. P. Burgess, Pramana 45 , S47 (1995), [arXiv:hep-ph/9411257]          *
 *        (see also references)                                                   *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/
#include "GSTU/A0lepFB.h"

ClassImp(GSTU::A0lepFB)

GSTU::A0lepFB::A0lepFB(): SMPredictions(){}

Double_t GSTU::A0lepFB::GetTheoryPrediction()
{
   Update();
 
   // see table 1 from hep-ph/9411257
   Double_t retVal = GetSM_A0lepFB() - 0.00677*GetS() + 0.00479*GetT() - 0.0146*GetX();
   
   return retVal;
}
