/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : Ab                                                                    *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/
#include "GSTU/Ab.h"
#include "GSTU/Alep.h"
#include "GSTU/A0bFB.h"

ClassImp(GSTU::Ab)

   GSTU::Ab::Ab(): Gfitter::GTheory()
{
   BookTheory   ( "GSTU::Alep",  &t_Alep  );   
   BookTheory   ( "GSTU::A0bFB", &t_A0bFB ); 
}

Double_t GSTU::Ab::GetTheoryPrediction()
{
   Double_t retVal(0.);   
   Double_t a0bfb = GetA0bFB();
   Double_t alep = GetAlep();
   retVal = 4/3.*a0bfb/alep;
   return retVal;
}

