/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : Ab                                                                    *
 *                                                                                *
 * Description:                                                                   *
 *      Prediction of asymmetry parameter of bottoms                              *
 *                                                                                *
 * Authors:                                                                       *
 *      Gfitter group                                                             *
 *                                                                                *
 * Redistribution and use in source and binary forms, with or without             *
 * modification, are permitted according to the terms listed in the file          *
 * LICENSE.                                                                       *
 **********************************************************************************/
#ifndef GSTU_Ab
#define GSTU_Ab

#include "Gfitter/GTheory.h"




namespace GSTU {

   class Alep;
   class A0bFB;

   class Ab : public Gfitter::GTheory {

   public:
      
      Ab();
      ~Ab() {}

      // Theory Prediction
      Double_t GetTheoryPrediction();

      // Initialise coefficients
      void Initialise() {}

   protected:

      // reference to Alep
      Alep& GetAlep() const { return (Alep&)*t_Alep; }      
      Gfitter::GTheoryRef    t_Alep; 

      // reference to A0bFB
      A0bFB& GetA0bFB() const { return (A0bFB&)*t_A0bFB; }      
      Gfitter::GTheoryRef    t_A0bFB; 
      
      ClassDef(Ab,0)
   };
}

#endif
