/**********************************************************************************
 * Project: GSTU - STU Parameter fitting package                                  *
 * Package: GSTU                                                                  *
 * Class  : Ac                                                                    *
 *                                                                                *
 * Description:                                                                   *
 *      Implementation                                                            *
 *                                                                                *
 * see corresponding .h file for author and license information                   *         
 *                                                                                *
 **********************************************************************************/
#include "GSTU/Ac.h"
#include "GSTU/Alep.h"
#include "GSTU/A0cFB.h"

ClassImp(GSTU::Ac)

   GSTU::Ac::Ac(): Gfitter::GTheory()
{
   BookTheory   ( "GSTU::Alep",  &t_Alep  );   
   BookTheory   ( "GSTU::A0cFB", &t_A0cFB ); 
}

Double_t GSTU::Ac::GetTheoryPrediction()
{
   Double_t retVal = 4/3.*GetA0cFB()/GetAlep();
   
   return retVal;
}
